function k=SaderPlanview;
% Calculates the spring constant for a rectangular cantilever, given the
% length, width and quality factor of the thermal oscillation in either air
% or water.
% Just follow the instructions.
% Uses: SaderHydroRect.m
disp('Give parameters:')
L   =1e-6*input('length                 (microns):      ');
W   =1e-6*input('width                  (microns):      ');
fluid=    input('fluid, type 1 for air or 2 for water :      ');
Q  =      input('Q                               :      ');
omega  =2000*pi*input('resonance frequency (kHz)       :      ');
if fluid==1
    rho=1.18;
    eta=1.86e-5;
elseif fluid==2
    rho=997;
    eta=8.59e-4;
else
    fluid=input ('last chance! what is the fluid? Type 1 for air, 2 for water');
    if fluid==1
        rho=1.18;
        eta=1.86e-5;
    else
        rho=997;
        eta=8.59e-4;
    end

end

imGamma=imag(SaderHydroRect(rho,eta,omega,W));
k=0.1906*rho*W^2*L*Q*imGamma*omega^2;


disp(sprintf('\f \n imaginary part of hydrodynamic function is %0.3g',imGamma))
disp(sprintf('spring constant is %0.3g', k))
